//								EJEMPLO 8
//						Autor: Mikel Etxebarria
//			(c) Ingeniera de Microsistemas Programados S.L.
//						www.microcontroladores.com
//								Bilbao 2006
//
//Juego de luces, otra temporizacin.
//
//Se desea realiza una rotacin secuencial en el encendido de cada led contectados a la
//puerta B del laboratorio PIC'School. Si RA0 = 0, la rotacin ser de derecha a izquierda 
//y viceversa. Cada led permanece encendido 0.25 segundos (250 mS)

#include <16f876A.h>

//Ajusta los valores de la palabra de configuracin durante el ensamblaje:
//Proteccin de cdigo y datos=OFF, LVP=OFF, WDT=OFF y OSC=XT

#fuses NOPROTECT,NOCPD,NOLVP,NOWDT,XT

// Con estas directivas las funciones "input" y "output_bit" no reprograman
// el pin de la puerta cada vez que son utilizadas. Si no se indica el
// modo fast_io se asume por defecto standard_io el cual reprograma el pin
// siempre antes de ser utilizadas estas funciones.

#use delay(clock=4000000) //Activa las temporizaciones en base al clock de trabajo
#use fast_io (A)
#use fast_io (B)

int	x=1;				//Variable para el valor de salida

main()
{  
	setup_adc_ports(NO_ANALOGS);	//Puerta A digital
  	set_tris_a(0x3F);				//Puerta A entrada
  	set_tris_b(0x00);				//Puerta B salida
	  
	while(1)
		{   
			output_b(x);			//Salida	
			delay_ms(250);			//Temporiza 0.25"
			if (input(PIN_A0))						
			rotate_right(&x,1);		//Desplaza a la derecha
			else 						
			rotate_left(&x,1);		// Desplaza a la izquierda	
		}	
}

